//
//  EquipmentPackages.h
//  EC145Gen
//
//  Created by Vadim on 4/22/14.
//
//

#import <Foundation/Foundation.h>

@class MedicalPackage;
@interface EquipmentPackages : NSObject

@property NSArray* packages;
@property (nonatomic) float totalWeight;
@property (nonatomic) float totalArm;
@property (nonatomic) float totalMoment;
@property (nonatomic) float totalArmLat;
@property (nonatomic) float totalMomentLat;
@property (nonatomic) NSString* totalWeightString;
@property (nonatomic) NSString* totalArmString;
@property (nonatomic) NSString* totalMomentString;
@property (nonatomic) NSString* totalArmLatString;
@property (nonatomic) NSString* totalMomentLatString;
@property NSString* uploadURL;
@property NSString* downloadURL;
@property (readonly) NSString* serializeKey;
@property int configNumber;

- (id)initWithSerializeKey:(NSString*)key;
- (id)initWithPackages:(EquipmentPackages*)packages andSerializeKey:(NSString*)key;
- (void)resetForSerializeKey:(NSString*)key;
- (void)setWeightUnits:(bool)isKg;
- (MedicalPackage*)createNewPackage;
- (void)deletePackage:(MedicalPackage*)package;
- (void)addPackage:(MedicalPackage*)package;
- (void)saveToFile;
+ (EquipmentPackages*)packageForKey:(NSString*)key;
- (void)copyFromPackage:(EquipmentPackages*)package;
- (void)wipeOut;

- (void)uploadPackagesFileWithCompletionBlock:(void(^)(bool status, NSString* error))block;
- (void)downloadPackagesFileWithCompletionBlock:(void(^)(bool status, NSString* error))block;

@end
